jQuery(document).ready(function($) {
		function getUTMParameters() {
		var utmParams = {};
		var queryString = window.location.search.substring(1);
		var queryParams = queryString.split("&");

		for (var i = 0; i < queryParams.length; i++) {
		var pair = queryParams[i].split("=");
			var key = decodeURIComponent(pair[0]);
			var value = decodeURIComponent(pair[1]);

			if (key.indexOf("utm_") === 0) {
				utmParams[key] = value;
			}
		}

		return utmParams;
	}

	// Function to set UTM parameters in a cookie
	function setUTMCookie(utmParams) {
		var expiryDate = new Date();
		document.cookie = "utm_params=" + encodeURIComponent(JSON.stringify(utmParams)) + "; path=/";
	}

	// Function to get UTM parameters from a cookie
	function getUTMCookie() {
		var cookieName = "utm_params=";
		var decodedCookie = decodeURIComponent(document.cookie);
		var cookieArray = decodedCookie.split(';');

		for (var i = 0; i < cookieArray.length; i++) {
			var cookie = cookieArray[i].trim();
			if (cookie.indexOf(cookieName) == 0) {
				return JSON.parse(cookie.substring(cookieName.length, cookie.length));
			}
		}

		return {};
	}

	// Check if UTM parameters exist in the URL
	var utmParamsFromURL = getUTMParameters();
		if (Object.keys(utmParamsFromURL).length > 0) {
		// UTM parameters found in the URL, set them in the cookie
		setUTMCookie(utmParamsFromURL);
	}

	function isEmpty(obj) {
		return $.isEmptyObject(obj);
	}

	// Function to update links with UTM parameters
	function updateLinksWithUTM() {
		var utmParams = getUTMCookie();

		if(!isEmpty(utmParams)) {
			var links = document.querySelectorAll('a');

			links.forEach(function (link) {
				var href = link.href;

				if($(link).hasClass('video-popup-trigger') || href.indexOf('#') >= 0) {
					return;
				}

				if (href.indexOf("?") != -1) {
					// If the link already has some query parameters
					link.href += "&";
				} else {
					link.href += "?";
				}

				// Add UTM parameters to the link
				for (var key in utmParams) {
					link.href += key + "=" + utmParams[key] + "&";
				}

				// Remove the trailing "&" if it exists
				link.href = link.href.replace(/&$/, "");
			});
		}
	}

	// Call the function to update links on page load
	updateLinksWithUTM();
});