<?php
/**
 * Plugin Name: Artemis UTM Tracker
 * Plugin URI: https://weareartemis.co.uk/
 * Description: Maintains UTM tracking code across all pages
 * Version: 1.0
 * Author: SJP
 * Author URI: https://weareartemis.co.uk/
 * Update URI: https://plugins.madeofmore.agency/info.json
 * Text Domain: artemis-utm-tracker
 * Requires at least: 5.4
 * Requires PHP: 7.2
 */

if( ! function_exists( 'mom_check_for_updates' ) ){
  function mom_check_for_updates( $update, $plugin_data, $plugin_file ){
      static $response = false;

      if( empty( $plugin_data['UpdateURI'] ) || ! empty( $update ) )
          return $update;

      if( $response === false && ! is_wp_error( $response ) )
          $response = wp_remote_get( $plugin_data['UpdateURI'] );

      if( empty( $response['body'] ) )
          return $update;

      $custom_plugins_data = json_decode( $response['body'], true );

      if( ! empty( $custom_plugins_data[ $plugin_file ] ) )
          return $custom_plugins_data[ $plugin_file ];
      else
          return $update;

  }

  add_filter('update_plugins_plugins.madeofmore.agency', 'mom_check_for_updates', 10, 3);
}

function load_plugin_assets() {
	$date = date("i");
	wp_enqueue_script('artemis-utm-tracker', plugins_url('artemis-utm-tracker/app.js'), array('jquery'), 1.0, true);
}
add_action('wp_enqueue_scripts', 'load_plugin_assets');