<?php
/*
Plugin Name: CF7 ClickD Integration
Description: Updating Legacy Artemis sites to submit to ClickD using CF7
*/

/**
 * Plugin Name: CF7 ClickD Integration
 * Plugin URI: https://www.wedding-venues.co.uk/
 * Description: Updating Legacy Artemis sites to submit to ClickD using CF7
 * Version: 1.1.91
 * Author: SJP
 * Author URI: https://madeofmore.agency/
 * Update URI: https://plugins.madeofmore.agency/info.json
 * Text Domain: cf7-clickd-integration
 * Requires at least: 5.4
 * Requires PHP: 7.2
 */

if( ! function_exists( 'mom_check_for_updates' ) ){
  function mom_check_for_updates( $update, $plugin_data, $plugin_file ){
      static $response = false;

      if( empty( $plugin_data['UpdateURI'] ) || ! empty( $update ) )
          return $update;

      if( $response === false && ! is_wp_error( $response ) )
          $response = wp_remote_get( $plugin_data['UpdateURI'] );

      if( empty( $response['body'] ) )
          return $update;

      $custom_plugins_data = json_decode( $response['body'], true );

      if( ! empty( $custom_plugins_data[ $plugin_file ] ) )
          return $custom_plugins_data[ $plugin_file ];
      else
          return $update;

  }

  add_filter('update_plugins_plugins.madeofmore.agency', 'mom_check_for_updates', 10, 3);
}

function action_wpcf7_before_send_mail($contact_form) {
	$id = $contact_form->id();

    $wpcf7 = WPCF7_ContactForm::get_current();
    $submission = WPCF7_Submission::get_instance();
    $form = $submission->get_posted_data();
    $form_title = $wpcf7->title;
    $form_id = $wpcf7->id;
	$actionUrl = $form['actionurl'];

	// Select fields
	$enquiry_category = $form['enquiry_category'][0] ?? null;
	$event_type = $form['event_type'][0] ?? null;
	$approxweddingguests = $form['approxweddingguests'][0] ?? null;
	$whereholdingceremony = $form['whereholdingceremony'][0] ?? null;
	$venuehiretype = $form['venuehiretype'][0] ?? null;
	$hearabout = $form['hearabout'][0] ?? null;
	$wedding_year = $form['wedding_year'][0] ?? null;
	// if($wedding_year):
	// 	$wedding_year = implode(', ', $wedding_year);
	// endif;

	$gdpr = 'Off';
    if($form['gdpr'] == 1):
    	$gdpr = 'On';
    endif;

	$postData = [
		'newlead'				=> 1,
		'firstname' 			=> $form['firstname'],
		'lastname' 				=> $form['lastname'],
		'email' 				=> $form['email'],
		'telephone' 			=> $form['telephone'],
		'postcode' 				=> $form['postcode'],
		'preferred_date' 		=> $form['preferred_date'],
		'preferred_time'		=> $form['preferred_time'],
		'venue_id' 				=> $form['venue_id'],
		'source_id' 			=> $form['source_id'],
		'comments' 				=> $form['comments'],
		'enquiry_category' 		=> $enquiry_category,
		'enquiry_type' 			=> $form['enquiry_type'],
		'venuehiretype' 		=> $venuehiretype,
		'whereholdingceremony' 	=> $whereholdingceremony,
		'campaign_utm' 			=> $form['utm_campaign'],
		'medium_utm' 			=> $form['utm_medium'],
		'source_utm' 			=> $form['utm_source'],
		'appointment_id'		=> $form['appointment_id'],
		'preferred_datetime'	=> $form['preferred_datetime'],
		'company_name'			=> $form['company_name'],
		'approxweddingguests'	=> $approxweddingguests,
		'event_type'			=> $event_type,
		'memail' 				=> $gdpr,
		'msms' 					=> $gdpr,
		'mphone'		 		=> $gdpr,
		'mpost' 				=> $gdpr,
		'role_in_wedding' 		=> NULL,
		'no_people_attending' 	=> $form['no_people_attending'],
		'year'					=> $wedding_year,
		'partners_firstname' 	=> $form['partners_firstname'],
		'partners_lastname' 	=> $form['partners_lastname'],
		'redirectpath' 			=> home_url() . '/' . $form['redirectpath'],
		'hearabout' 			=> $hearabout,
	];

	$headers = array(
	  'Content-Type: application/x-www-form-urlencoded;',
	  'Charset: UTF-8;',
	  'Referer: '. home_url()
	);

	//  Setup cURL
	$curl = curl_init();
	curl_setopt_array($curl, array(
	  CURLOPT_URL => $actionUrl,
	  CURLOPT_HTTPHEADER => $headers,
	  CURLOPT_POST => TRUE,
	  CURLOPT_POSTFIELDS => http_build_query( $postData ),
	  CURLOPT_RETURNTRANSFER => TRUE,
	  CURLOPT_VERBOSE => TRUE,
	  CURLINFO_HEADER_OUT => TRUE
	));
	$request = curl_getinfo($curl);

	//  Handle response
	$response = curl_exec($curl);
	curl_close($curl);
}
add_action( 'wpcf7_before_send_mail', 'action_wpcf7_before_send_mail', 10, 1 );
?>
